/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For complete reference see:
	// http://docs.ckeditor.com/#!/api/CKEDITOR.config

	// The toolbar groups arrangement, optimized for two toolbar rows.
	config.toolbarGroups = [
		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
		{ name: 'links' },
		{ name: 'insert' },
		{ name: 'forms' },
		{ name: 'tools' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'others' },
		'/',
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
		{ name: 'styles' },
		{ name: 'colors' },
		{ name: 'about' }
	];

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	config.removeButtons = 'Underline,Subscript,Superscript';

	// Set the most common block elements.
	// config.format_tags = 'p;h1;h2;h3;pre';
	config.format_tags = 'p;h1;h2;h3;h4;h5;h6;pre;address;div';

	config.allowedContent = true; //do not change pasted html property code


	// Simplify the dialog windows.
	config.removeDialogTabs = 'image:advanced;link:advanced';
	
	// BootstrapCK Skin Options
	config.skin = 'bootstrapck';
	config.height = '350px';


	//added config
	config.language = 'zh';
	config.image_previewText=' ';
	//開啟圖片上傳功能
	// config.filebrowserUploadUrl = 'uploadimg.php?type=Files';
	// config.filebrowserImageUploadUrl = 'uploadimg.php?type=Images';

	 // baseUrl 
	config.filebrowserImageUploadUrl ='http://amigo.at-appmaker.com/admin/' + 'ckeditor/image_upload';
    config.filebrowserUploadUrl = 'http://amigo.at-appmaker.com/admin/' + 'ckeditor/file_upload';
	//end added config

};
