<?php
class Blog_list_Model extends CI_Model{
        
        function insert($arr)
        {
                
                $this->db->insert('blog_list', $arr);
                return $this->db->insert_id();
                
        }
        
        function update($id, $arr)
        {
        
                $this->db->where('id', $id);
                $this->db->update('blog_list', $arr);
        
        }
        
        function get()
        {       

                    $this->db->select('blog_list.id,blog_list.cover_img_link,blog_list.code,blog_list.title, blog_list.date, blog_list.description, blog_list.content, blog_list.status, blog_list.display, blog_list.display_order, blog_list.update_time');
                    
                   
                    
                    $this->db->from('blog_list');
                    $this->db->where('is_deleted', 0);
                     $this->db->order_by("blog_list.date desc");
                    $query=$this->db->get();
                    //echo $this->db->last_query();
                return $query->result();
        }
        
        function get_id($id){
                $this->db->where('id', $id);
                $query = $this->db->get('blog_list');
                return $query->result();
                // $row = $query->row();
                // return $row;
        }
        
        function get_lang($lang)
        {
                
                $this->db->where('lang', $lang);
                $query = $this->db->get('blog_list');
                return $query->result();
                
        }
        
        function delete($id)
        {
                $arr=array();
                $arr['is_deleted'] =1;
                $this->db->where('id', $id);
                $this->db->update('blog_list', $arr);
        }
    public function getView($data) {

        //ajax blog load content


        $field = 'blog_list.id,blog_list.cover_img_link,blog_list.title,blog_list.date';
        $this->db->select($field)->from('blog_list')->order_by('blog_list.display_order DESC, blog_list.create_time DESC, blog_list.id DESC');
        $this->db->where(['blog_list.status != ' => 0, 'blog_list.display' => 1, 'blog_list.is_deleted' => 0]);

        if (isset($data['tag_id']) && !empty($data['tag_id'])) {
            $this->db->join('blog_tag_hub', 'blog_tag_hub.blog_id = blog_list.id');
            $this->db->where(['blog_tag_hub.tag_id' => $data['tag_id']]);
        }
//        $this->db->join('tag_list', 'tag_list.id = blog_tag_hub.tag_id');
//        $this->db->where(['tag_list.status' => 1, 'tag_list.display' => 1]);

        $page = isset($data['page']) && !empty($data['page']) ? $data['page'] - 1 : 0;
        $pages = 0;
        $per = $data['per'];
        if (is_numeric($page)) {
            $page = $page < 0 ? 0 : $page;
            $pages = $page * $per;
        }

//        $sql = $this->db->get_compiled_select(false); echo $sql; 
        //獲得
        $count = $this->db->count_all_results('', FALSE);
        $pages = $pages > $count ? $count - $per : $pages;
        $query = $this->db->limit($per, $pages)->get(); //limit(數量,起點)
        $result = [];
        foreach ($query->result_array() as $row) {
            $this->db->select('blog_tag_list.id,blog_tag_list.name,blog_tag_list.color')->from('blog_tag_list')
                    ->join('blog_tag_hub', 'blog_tag_hub.tag_id = blog_tag_list.id')
                    ->where(['blog_tag_hub.blog_id' => $row['id']]);
            $this->db->where(['blog_tag_list.status' => 1, 'blog_tag_list.deleted' => 0]);
            $this->db->where(['blog_tag_hub.status' => 1]);
            $tags = $this->db->get();
            $row['tag'] = $tags->result_array();

            $result[] = $row;
        }

        return [$result, $count];
    }
    function countNumOfBlog(){
            $this->db->select('id');
            $this->db->from('blog_list');
            $this->db->where('is_deleted', 0);
            $query=$this->db->get();
            $num=$query->num_rows();

            return $num;
    }
        
}

?>