<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Example use of the CodeIgniter Sitemap Generator Model
 * 
 * @author Gerard Nijboer <me@gerardnijboer.com>
 * @version 1.0
 * @access public
 *
 */
class Sitemap extends CI_Controller {

	public function __construct() {
		parent::__construct();
		// We load the url helper to be able to use the base_url() function
		$this->load->helper('url');
		
		$this->load->model('sitemapmodel');
		
		// Array of some articles for demonstration purposes
		$this->articles = array(
			array(
				'loc' => base_url('articles/lorem-ipsum-dolor-sit-amet'),
				'lastmod' => date('Y-m-d', time()),
				'changefreq' => 'monthly',
				'priority' => 0.5
			),
			array(
				'loc' => base_url('articles/consectetur-adipiscing-elit'),
				'lastmod' => date('Y-m-d', time()),
				'changefreq' => 'monthly',
				'priority' => '1'
			),
			array(
				'loc' => base_url('articles/nullam-nec-magna-eu-tellus-placerat-tempus'),
				'lastmod' => date('Y-m-d', time()),
				'changefreq' => 'monthly',
				'priority' => false
			)
		);
		$this->load->model('Landingcontentmultistyle_Model','landingcontentmultistyle_model');

	}
	
	/**
	 * Generate a sitemap index file
	 * More information about sitemap indexes: http://www.sitemaps.org/protocol.html#index
	 */
	public function index() {

		//notes
		//call sitemap/index can create and sumbit sitemap
		//but it return some text notice sitemap submit successful
		



		$this->sitemapmodel->add(base_url('sitemap/general'), date('Y-m-d', time()));
		$this->sitemapmodel->add(base_url('sitemap/articles'), date('Y-m-d', time()));
		$this->sitemapmodel->add(base_url('sitemap/general'), date('Y-m-d', time()),NULL,1);
		$this->sitemapmodel->add(base_url('sitemap/general'), date('Y-m-d', time()),NULL,0.8);
		// $this->sitemapmodel->output('sitemapindex');
		// $landingmenu=$this->landingcontentmultistyle_model->get();
		// foreach($landingmenu as $landingrow){
		// 	echo $landingrow->h1;
		// 	echo "<br>";
		// }
		//add first base url
		$this->sitemapmodel->add(base_url(), date('Y-m-d', time()),NULL,1);
		//end 

		//add landing page
		$landingmenu=$this->landingcontentmultistyle_model->get();
		foreach($landingmenu as $landingrow){
			// echo $landingrow->h1;
			// echo "<br>";
			$this->sitemapmodel->add(base_url('主頁/'.$landingrow->h1), date('Y-m-d', time()),NULL,0.8);
		}//foreach($landingmenu as $landingrow){
		//end add landing page

		//add main web
		$this->sitemapmodel->add(base_url('mainweb/'), date('Y-m-d', time()),NULL,0.8);
		//end add main web

		//add 關於我們 web
		$this->sitemapmodel->add(base_url('%E9%97%9C%E6%96%BC%E6%88%91%E5%80%91/'), date('Y-m-d', time()),NULL,0.8);
		//end add 關於我們 web

		//add 療程服務
		//end add 療程服務

		//add 輕美容
		//end add 輕美容

		//add 免費諮詢
		$this->sitemapmodel->add(base_url('%E5%85%8D%E8%B2%BB%E8%AB%AE%E8%A9%A2/'), date('Y-m-d', time()),NULL,0.8);
		
		//end add 免費諮詢


		// 美容專欄
		$this->sitemapmodel->add(base_url('%E7%BE%8E%E5%AE%B9%E5%B0%88%E6%AC%84/'), date('Y-m-d', time()),NULL,0.8);
		
		// end 美容專欄

		//美容專欄內容
		//blog list model get


		//end 美容專欄內容

		//聯絡我們
		$this->sitemapmodel->add(base_url('%E8%81%AF%E7%B5%A1%E6%88%91%E5%80%91/'), date('Y-m-d', time()),NULL,0.8);
		//end 聯絡我們

		$data=$this->sitemapmodel->output('urlset');
		$this->writeSitemap($data);
		$this->submitSitemap();

	}
	
	/**
	 * Generate a sitemap both based on static urls and an array of urls
	 */
	public function general() {
		$this->sitemapmodel->add(base_url(), NULL, 'monthly', 1);
		$this->sitemapmodel->add(base_url('contact'), NULL, 'monthly', 0.9);

		foreach ($this->articles as $article) {
			$this->sitemapmodel->add($article['loc'], $article['lastmod'], $article['changefreq'], $article['priority']);
		}
		$this->sitemapmodel->output();
	}
	
	/**
	 * Generate a sitemap only on an array of urls
	 */
	public function articles() {
		foreach ($this->articles as $article) {
			$this->sitemapmodel->add($article['loc'], $article['lastmod'], $article['changefreq'], $article['priority']);
		}
		$this->sitemapmodel->output();
	}

	private function writeSitemap($xml){
		// $this->load->helper('file');
		// $data = 'My Text here';

		// if ( !write_file('./path/to/file.txt', $data)){
		// if ( !write_file( $_SERVER['DOCUMENT_ROOT']."/assets/images/uploads/".'file.txt', $data)){
		// if ( !write_file( $_SERVER['DOCUMENT_ROOT']."/assets/images/uploads/".'sitemap.xml', $inputdata)){
		//      echo 'Unable to write the file';
		// }
		// echo $xml->saveXML($_SERVER['DOCUMENT_ROOT']."/assets/images/uploads/".'sitemap.xml');
		$xml->saveXML($_SERVER['DOCUMENT_ROOT']."/assets/images/uploads/".'sitemap.xml');
	}

	private function submitSitemap(){
		// $url = "http://www.google.com/webmasters/sitemaps/ping?sitemap=".$s;
		$s=base_url()."/assets/images/uploads/".'sitemap.xml';
		$url = "http://www.google.com/webmasters/sitemaps/ping?sitemap=".$s;
	    $returnCode = $this->myCurl($url);
	    // echo "Google Sitemaps has been pinged (return code: {$returnCode}).\n";
	}
	private function myCurl($url){
	    $ch = curl_init($url);
	    curl_setopt($ch, CURLOPT_HEADER, 0);
	    curl_exec($ch);
	    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	    curl_close($ch);
	    return $httpCode;
	}
	
}

?>